/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import org.dojotoolkit.shrinksafe.TokenMapper;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.UintMap;

public class Compressor {
    private static final int FUNCTION_END = 160;
    private static final boolean printSource = false;
    public static TokenMapper tm = new TokenMapper();

    private static String compress(String string, int n, UintMap uintMap, ScriptOrFnNode scriptOrFnNode, boolean bl) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 == 0) {
            return "";
        }
        int n5 = uintMap.getInt(1, 0);
        if (n5 < 0) {
            throw new IllegalArgumentException();
        }
        int n6 = uintMap.getInt(2, 4);
        if (n6 < 0) {
            throw new IllegalArgumentException();
        }
        int n7 = uintMap.getInt(3, 2);
        if (n7 < 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = 0 != (n & 1);
        boolean bl3 = 0 != (n & 2);
        int n8 = 0;
        boolean bl4 = false;
        int n9 = 0;
        char c = '\u0000';
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (string.charAt(n9) == '\u0087') {
            ++n9;
            n3 = -1;
        } else {
            n3 = string.charAt(n9 + 1);
        }
        if (!bl3) {
            for (n2 = 0; n2 < n5; ++n2) {
                stringBuffer.append("");
            }
        } else if (n3 == 2) {
            stringBuffer.append('(');
        }
        block94: while (n9 < n4) {
            if (n9 > 0) {
                c = string.charAt(n9 - 1);
            }
            switch (string.charAt(n9)) {
                case '\'': 
                case '0': {
                    n2 = Compressor.getSourceStringEnd(string, n9 + 1, bl);
                    if ('B' == string.charAt(n2)) {
                        n9 = Compressor.printSourceString(string, n9 + 1, false, stringBuffer, bl);
                        continue block94;
                    }
                    n9 = tm.sourceCompress(string, n9 + 1, false, stringBuffer, c, bl6, n8, scriptOrFnNode);
                    continue block94;
                }
                case ')': {
                    n9 = Compressor.printSourceString(string, n9 + 1, true, stringBuffer, bl);
                    continue block94;
                }
                case '(': {
                    n9 = Compressor.printSourceNumber(string, n9 + 1, stringBuffer);
                    continue block94;
                }
                case '-': {
                    stringBuffer.append("true");
                    break;
                }
                case ',': {
                    stringBuffer.append("false");
                    break;
                }
                case '*': {
                    stringBuffer.append("null");
                    break;
                }
                case '+': {
                    stringBuffer.append("this");
                    break;
                }
                case 'l': {
                    ++n9;
                    ++Compressor.tm.functionNum;
                    bl7 = true;
                    bl5 = true;
                    stringBuffer.append("function");
                    if (86 == Compressor.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case '\u00a0': {
                    break;
                }
                case 'X': {
                    stringBuffer.append(",");
                    break;
                }
                case 'T': {
                    ++n8;
                    if (1 == Compressor.getNext(string, n4, n9)) {
                        n5 += n6;
                    }
                    stringBuffer.append('{');
                    break;
                }
                case 'U': {
                    tm.leaveNestingLevel(n8);
                    if (bl2 && --n8 == 0) break;
                    stringBuffer.append('}');
                    switch (Compressor.getNext(string, n4, n9)) {
                        case 1: 
                        case 160: {
                            if (Compressor.getNext(string, n4, n9 + 1) != 81 && Compressor.getNext(string, n4, n9 + 1) != 86 && Compressor.getNext(string, n4, n9 + 1) != 87 && Compressor.getNext(string, n4, n9 + 1) != 83 && Compressor.getNext(string, n4, n9 + 1) != 85 && Compressor.getNext(string, n4, n9 + 1) != 88 && Compressor.getNext(string, n4, n9 + 1) != 102 && Compressor.getNext(string, n4, n9 + 1) != 107 && Compressor.getNext(string, n4, n9) == 160) {
                                stringBuffer.append(';');
                            }
                            n5 -= n6;
                            break;
                        }
                        case 112: 
                        case 116: {
                            n5 -= n6;
                            stringBuffer.append("");
                        }
                    }
                    break;
                }
                case 'V': {
                    if (bl7) {
                        bl6 = true;
                        bl7 = false;
                    }
                    if (bl5) {
                        tm.enterNestingLevel(n8);
                        bl5 = false;
                    }
                    stringBuffer.append('(');
                    break;
                }
                case 'W': {
                    if (bl6) {
                        bl6 = false;
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 'R': {
                    stringBuffer.append('[');
                    break;
                }
                case 'S': {
                    stringBuffer.append(']');
                    break;
                }
                case '\u0001': {
                    int n10;
                    if (bl3) break;
                    boolean bl8 = true;
                    if (!bl4) {
                        bl4 = true;
                        if (bl2) {
                            stringBuffer.setLength(0);
                            n5 -= n6;
                            bl8 = false;
                        }
                    }
                    if (bl8) {
                        stringBuffer.append('\n');
                    }
                    if (n9 + 1 >= n4) break;
                    int n11 = 0;
                    char c2 = string.charAt(n9 + 1);
                    if (c2 == 'r' || c2 == 's') {
                        n11 = n6 - n7;
                    } else if (c2 == 'U') {
                        n11 = n6;
                    } else if (c2 == '\'' && string.charAt(n10 = Compressor.getSourceStringEnd(string, n9 + 2, bl)) == 'f') {
                        n11 = n6;
                    }
                    while (n11 < n5) {
                        stringBuffer.append("");
                        ++n11;
                    }
                    break;
                }
                case 'k': {
                    stringBuffer.append('.');
                    break;
                }
                case '\u001e': {
                    stringBuffer.append("new ");
                    break;
                }
                case '\u001f': {
                    stringBuffer.append("delete ");
                    break;
                }
                case 'o': {
                    stringBuffer.append("if");
                    break;
                }
                case 'p': {
                    stringBuffer.append("else");
                    break;
                }
                case 'v': {
                    stringBuffer.append("for");
                    break;
                }
                case '4': {
                    stringBuffer.append(" in ");
                    break;
                }
                case 'z': {
                    stringBuffer.append("with");
                    break;
                }
                case 't': {
                    stringBuffer.append("while");
                    break;
                }
                case 'u': {
                    stringBuffer.append("do");
                    break;
                }
                case 'P': {
                    stringBuffer.append("try");
                    break;
                }
                case '{': {
                    stringBuffer.append("catch");
                    break;
                }
                case '|': {
                    stringBuffer.append("finally");
                    break;
                }
                case '2': {
                    stringBuffer.append("throw ");
                    break;
                }
                case 'q': {
                    stringBuffer.append("switch");
                    break;
                }
                case 'w': {
                    stringBuffer.append("break");
                    if (39 != Compressor.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'x': {
                    stringBuffer.append("continue");
                    if (39 != Compressor.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'r': {
                    stringBuffer.append("case ");
                    break;
                }
                case 's': {
                    stringBuffer.append("default");
                    break;
                }
                case '\u0004': {
                    stringBuffer.append("return");
                    if (81 == Compressor.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'y': {
                    stringBuffer.append("var ");
                    break;
                }
                case 'Q': {
                    stringBuffer.append(';');
                    break;
                }
                case 'Y': {
                    stringBuffer.append("=");
                    break;
                }
                case '`': {
                    stringBuffer.append("+=");
                    break;
                }
                case 'a': {
                    stringBuffer.append("-=");
                    break;
                }
                case 'b': {
                    stringBuffer.append("*=");
                    break;
                }
                case 'c': {
                    stringBuffer.append("/=");
                    break;
                }
                case 'd': {
                    stringBuffer.append("%=");
                    break;
                }
                case 'Z': {
                    stringBuffer.append("|=");
                    break;
                }
                case '[': {
                    stringBuffer.append("^=");
                    break;
                }
                case '\\': {
                    stringBuffer.append("&=");
                    break;
                }
                case ']': {
                    stringBuffer.append("<<=");
                    break;
                }
                case '^': {
                    stringBuffer.append(">>=");
                    break;
                }
                case '_': {
                    stringBuffer.append(">>>=");
                    break;
                }
                case 'e': {
                    stringBuffer.append("?");
                    break;
                }
                case 'B': {
                    stringBuffer.append(':');
                    break;
                }
                case 'f': {
                    if (1 == Compressor.getNext(string, n4, n9)) {
                        stringBuffer.append(':');
                        break;
                    }
                    stringBuffer.append(":");
                    break;
                }
                case 'g': {
                    stringBuffer.append("||");
                    break;
                }
                case 'h': {
                    stringBuffer.append("&&");
                    break;
                }
                case '\t': {
                    stringBuffer.append("|");
                    break;
                }
                case '\n': {
                    stringBuffer.append("^");
                    break;
                }
                case '\u000b': {
                    stringBuffer.append("&");
                    break;
                }
                case '.': {
                    stringBuffer.append("===");
                    break;
                }
                case '/': {
                    stringBuffer.append("!==");
                    break;
                }
                case '\f': {
                    stringBuffer.append("==");
                    break;
                }
                case '\r': {
                    stringBuffer.append("!=");
                    break;
                }
                case '\u000f': {
                    stringBuffer.append("<=");
                    break;
                }
                case '\u000e': {
                    stringBuffer.append("<");
                    break;
                }
                case '\u0011': {
                    stringBuffer.append(">=");
                    break;
                }
                case '\u0010': {
                    stringBuffer.append(">");
                    break;
                }
                case '5': {
                    stringBuffer.append(" instanceof ");
                    break;
                }
                case '\u0012': {
                    stringBuffer.append("<<");
                    break;
                }
                case '\u0013': {
                    stringBuffer.append(">>");
                    break;
                }
                case '\u0014': {
                    stringBuffer.append(">>>");
                    break;
                }
                case ' ': {
                    stringBuffer.append("typeof ");
                    break;
                }
                case '}': {
                    stringBuffer.append("void ");
                    break;
                }
                case '\u001a': {
                    stringBuffer.append('!');
                    break;
                }
                case '\u001b': {
                    stringBuffer.append('~');
                    break;
                }
                case '\u001c': {
                    stringBuffer.append('+');
                    break;
                }
                case '\u001d': {
                    stringBuffer.append('-');
                    break;
                }
                case 'i': {
                    if ('\u0015' == c) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append("++");
                    if (21 != Compressor.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'j': {
                    if ('\u0016' == c) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append("--");
                    if (22 != Compressor.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case '\u0015': {
                    stringBuffer.append("+");
                    break;
                }
                case '\u0016': {
                    stringBuffer.append("-");
                    break;
                }
                case '\u0017': {
                    stringBuffer.append("*");
                    break;
                }
                case '\u0018': {
                    stringBuffer.append("/");
                    break;
                }
                case '\u0019': {
                    stringBuffer.append("%");
                    break;
                }
                case '\u008f': {
                    stringBuffer.append("::");
                    break;
                }
                case '\u008e': {
                    stringBuffer.append("..");
                    break;
                }
                case '\u0092': {
                    stringBuffer.append('@');
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++n9;
        }
        if (bl3 && n3 == 2) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static int getNext(String string, int n, int n2) {
        return n2 + 1 < n ? (int)string.charAt(n2 + 1) : 0;
    }

    private static int getSourceStringEnd(String string, int n, boolean bl) {
        return Compressor.printSourceString(string, n, false, null, bl);
    }

    private static int printSourceString(String string, int n, boolean bl, StringBuffer stringBuffer, boolean bl2) {
        int n2 = string.charAt(n);
        ++n;
        if ((0x8000 & n2) != 0) {
            n2 = (Short.MAX_VALUE & n2) << 16 | string.charAt(n);
            ++n;
        }
        if (stringBuffer != null) {
            String string2 = string.substring(n, n + n2);
            if (!bl) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(Compressor.escapeString(string2, bl2));
                stringBuffer.append('\"');
            }
        }
        return n + n2;
    }

    private static int printSourceNumber(String string, int n, StringBuffer stringBuffer) {
        double d = 0.0;
        char c = string.charAt(n);
        ++n;
        if (c == 'S') {
            if (stringBuffer != null) {
                char c2 = string.charAt(n);
                d = c2;
            }
            ++n;
        } else if (c == 'J' || c == 'D') {
            if (stringBuffer != null) {
                long l = (long)string.charAt(n) << 48;
                l |= (long)string.charAt(n + 1) << 32;
                l |= (long)string.charAt(n + 2) << 16;
                d = c == 'J' ? (double)l : Double.longBitsToDouble(l |= (long)string.charAt(n + 3));
            }
            n += 4;
        } else {
            throw new RuntimeException();
        }
        if (stringBuffer != null) {
            stringBuffer.append(ScriptRuntime.numberToString((double)d, (int)10));
        }
        return n;
    }

    private static String escapeString(String string, boolean bl) {
        return Compressor.escapeString(string, '\"', bl);
    }

    private static String escapeString(String string, char c, boolean bl) {
        if (c != '\"' && c != '\'') {
            Kit.codeBug();
        }
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            char c2 = string.charAt(i);
            if (' ' <= c2 && c2 <= '~' && c2 != c && c2 != '\\') {
                if (stringBuffer == null) continue;
                stringBuffer.append(c2);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append(string);
                stringBuffer.setLength(i);
            }
            int n2 = -1;
            switch (c2) {
                case '\b': {
                    n2 = 98;
                    break;
                }
                case '\f': {
                    n2 = 102;
                    break;
                }
                case '\n': {
                    n2 = 110;
                    break;
                }
                case '\r': {
                    n2 = 114;
                    break;
                }
                case '\t': {
                    n2 = 116;
                    break;
                }
                case '\u000b': {
                    n2 = 118;
                    break;
                }
                case ' ': {
                    n2 = 32;
                    break;
                }
                case '\\': {
                    n2 = 92;
                }
            }
            if (n2 >= 0) {
                stringBuffer.append('\\');
                stringBuffer.append((char)n2);
                continue;
            }
            if (c2 == c) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (bl || c2 == '\u0000') {
                int n3;
                if (c2 < '\u0100') {
                    stringBuffer.append("\\x");
                    n3 = 2;
                } else {
                    stringBuffer.append("\\u");
                    n3 = 4;
                }
                for (int j = (n3 - 1) * 4; j >= 0; j -= 4) {
                    int n4 = 0xF & c2 >> j;
                    int n5 = n4 < 10 ? 48 + n4 : 87 + n4;
                    stringBuffer.append((char)n5);
                }
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static final String compressScript(String string, int n, int n2) {
        return Compressor.compressScript(string, n, n2, false);
    }

    public static final String compressScript(String string, int n, int n2, boolean bl) {
        TokenMapper.reset();
        tm = new TokenMapper();
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        Parser parser = new Parser(compilerEnvirons, compilerEnvirons.getErrorReporter());
        ScriptOrFnNode scriptOrFnNode = parser.parse(string, null, n2);
        String string2 = parser.getEncodedSource();
        Interpreter interpreter = new Interpreter();
        interpreter.compile(compilerEnvirons, scriptOrFnNode, string2, false);
        UintMap uintMap = new UintMap(1);
        uintMap.put(1, n);
        return Compressor.compress(string2, 0, uintMap, scriptOrFnNode, bl);
    }
}

